
<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3  linea-gradiente-suave">
        <h1 class="h2">GESTION DE USUARIOS</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
          <div class="btn-group me-2">
            <!-- <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button> -->
          </div>
          <button type="button" class="btn btn-sm btn-outline-secondary" id="btnNuevoUsuario">
          <span data-feather="user-plus"></span> Nuevo Usuario
          </button>
        </div>
      </div>
  

      <!-- aqui empieza las cards informatias -->
    <div class="card-group">
            <div class="card card-gradient-blue position-relative">
                <div class="card-body">
                    <div>
                        <h2 id="totalEmpleados">0</h2>
                        <p>Empleados</p>
                    </div>
                <i data-feather="user" class="icon-feather"></i>
                </div>
            </div>
            <br>
        <div class="card card-gradient-green position-relative">
             <div class="card-body">
                    <div>
                        <h2 id="totalUsuarios">0</h2>
                        <p>Usuarios</p>
                    </div>
                <i data-feather="user-plus" class="icon-feather"></i>
                </div>
        </div>
         <br>  
        <div class="card card-gradient-orange position-relative">
            <div class="card-body">
                    <div>
                        <h2 id="totalActivos">0</h2>
                        <p>Inactivos</p>
                    </div>
                <i data-feather="user-x" class="icon-feather"></i>
                </div>
        </div>
    </div>
<!-- aqui terminan las cards informativas -->
<div class="container mt-5">
  <h3 class="mb-4">Gestión de Usuarios</h3>
  <div class="table-responsive">
    <table id="tablaUsuarios" class="table table-striped table-bordered">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Usuario</th>
          <th>Empleado</th>
          <th>Permiso</th>
          <th>Activo</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>




<!-- Modal Nuevo Usuario -->
<div class="modal fade" id="modalNuevoUsuario" tabindex="-1" aria-labelledby="nuevoUsuarioLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="nuevoUsuarioLabel">Crear Nuevo Usuario</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form id="formNuevoUsuario">
          
          <div class="mb-3">
            <label for="CorreoElectronicoNuevo" class="form-label">Correo Electrónico</label>
            <input type="email" class="form-control" id="CorreoElectronicoNuevo" name="CorreoElectronico" required>
          </div>

          <div class="mb-3">
            <label for="NombreUsuarioNuevo" class="form-label">Nombre de Usuario</label>
            <input type="text" class="form-control" id="NombreUsuarioNuevo" name="NombreUsuario" required>
          </div>

          <div class="mb-3">
            <label for="UPasswordNuevo" class="form-label">Contraseña</label>
            <input type="password" class="form-control" id="UPasswordNuevo" name="UPassword" required>
          </div>

          <div class="mb-3">
            <label for="IdEmpleadoNuevo" class="form-label">Empleado</label>
            <select class="form-select" id="IdEmpleadoNuevo" name="IdEmpleado" required>
              <!-- Opciones cargadas vía Ajax -->
            </select>
          </div>

          <div class="mb-3">
            <label for="IdPermisoNuevo" class="form-label">Permiso</label>
            <select class="form-select" id="IdPermisoNuevo" name="IdPermiso" required>
              <!-- Opciones cargadas vía Ajax -->
            </select>
          </div>

          <!-- Estado e IdEstablecimiento van fijos desde backend -->
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-success" id="btnGuardarUsuario">Guardar Usuario</button>
      </div>
    </div>
  </div>
</div>





<!-- Modal Editar Usuario -->
<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formEditarUsuario" class="w-100">
      <div class="modal-content">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title">Editar Usuario</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body row g-3">
          <input type="hidden" id="editIdUsuario" name="IdUsuario">

          <div class="col-md-6">
            <label for="editCorreo" class="form-label">Correo Electrónico</label>
            <input type="email" class="form-control" id="editCorreo" name="CorreoElectronico" required>
          </div>

          <div class="col-md-6">
            <label for="editUsuario" class="form-label">Nombre de Usuario</label>
            <input type="text" class="form-control" id="editUsuario" name="NombreUsuario" required>
          </div>

          <div class="col-md-6">
            <label for="editPassword" class="form-label">Contraseña</label>
            <input type="password" class="form-control" id="editPassword" name="UPassword" placeholder="Dejar vacío si no cambia">
          </div>

          <div class="col-md-6">
            <label for="editPermiso" class="form-label">Permiso</label>
            <select class="form-select" id="editPermiso" name="IdPermiso" required></select>
          </div>

          <div class="col-md-6">
            <label for="editEmpleado" class="form-label">Empleado</label>
            <input type="text" class="form-control" id="editEmpleado" name="Empleado" readonly>
          </div>

          <div class="col-md-6">
            <label for="editEstado" class="form-label">Estado</label>
            <select class="form-select" id="editEstado" name="IdEstado" required>
              <option value="1">Activo</option>
              <option value="2">Inactivo</option>
            </select>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success">💾 Guardar cambios</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>









<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<script>
//js para cards
$(document).ready(function(){
    // Feather icons
    feather.replace();

    // Cargar counts
    $.ajax({
        url: "<?= site_url('usuario/dashboardcounts'); ?>",
        type: "GET",
        dataType: "json",
        success: function(resp){
            $('#totalEmpleados').text(resp.empleados);
            $('#totalUsuarios').text(resp.usuarios);
            $('#totalActivos').text(resp.activos);
        },
        error: function(xhr){
            console.log("Error al cargar counts:", xhr.responseText);
        }
    });
});



  //js para mostrar informacion
$(document).ready(function () {
  $('#tablaUsuarios').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?= site_url('usuario/getusuarios'); ?>", // ruta al controller
      "type": "POST"
    },
    "columns": [
      { "data": "id" },
      { "data": "usuario" },
      { "data": "empleado" },
      { "data": "permiso" },
      { "data": "activo" },
      { "data": "acciones", "orderable": false, "searchable": false }
    ],
    "language": {
      "lengthMenu": "Mostrar _MENU_ entradas",
      "zeroRecords": "No se encontraron resultados",
      "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
      "infoEmpty": "Mostrando 0 a 0 de 0 entradas",
      "infoFiltered": "(filtrado de _MAX_ entradas totales)",
      "search": "Buscar:",
      "paginate": {
        "first": "Primero",
        "last": "Último",
        "next": "Siguiente",
        "previous": "Anterior"
      }
    },
    "pageLength": 10,
    "lengthMenu": [10, 25, 50, 100]
  });
});



// Evento para eliminar usuario
$('#tablaUsuarios').on('click', '.btn-delete', function(){
    var idUsuario = $(this).data('id');

    // SweetAlert de confirmación
    if(confirm("¿Seguro que deseas eliminar este usuario?")){
        $.ajax({
            url: "<?= site_url('usuario/deleteusuario'); ?>",
            type: "POST",
            data: { id: idUsuario },
            dataType: "json",
            success: function(response){
                if(response.status){
                    alert("Usuario eliminado correctamente");
                    $('#tablaUsuarios').DataTable().ajax.reload(null, false); // recarga la tabla
                }else{
                    alert("Error al eliminar el usuario");
                }
            },
            error: function(){
                alert("Error en la petición Ajax");
            }
        });
    }
});



// Evento para desactivar usuario
$('#tablaUsuarios').on('click', '.btn-desactivar', function(){
    var idUsuario = $(this).data('id');

    if(confirm("¿Seguro que deseas desactivar este usuario?")){
        $.ajax({
            url: "<?= site_url('usuario/desactivarusuario'); ?>",
            type: "POST",
            data: { id: idUsuario },
            dataType: "json",
            success: function(response){
                if(response.status){
                    alert("Usuario desactivado correctamente");
                    $('#tablaUsuarios').DataTable().ajax.reload(null, false);
                }else{
                    alert("Error al desactivar el usuario");
                }
            },
            error: function(xhr, status, error){
                console.log(xhr.responseText);
                alert("Error en la petición Ajax: " + error);
            }
        });
    }
});



// Abrir modal con datos del usuario
$('#tablaUsuarios').on('click', '.btn-editar', function(){
    var idUsuario = $(this).data('id');

    $.ajax({
        url: "<?= site_url('usuario/getusuariobyid'); ?>",
        type: "POST",
        data: { IdUsuario: idUsuario },
        dataType: "json",
        success: function(data){
            if(data){
                // Llenar campos
                $('#editIdUsuario').val(data.IdUsuario);
                $('#editCorreo').val(data.CorreoElectronico);
                $('#editUsuario').val(data.NombreUsuario);
                $('#editEmpleado').val(data.EmpleadoNombre); // viene join desde modelo
                $('#editEstado').val(data.IdEstado);

                // Cargar permisos dinámicamente
                $.ajax({
                    url: "<?= site_url('usuario/getpermisos'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function(permisos){
                        $('#editPermiso').empty();
                        $.each(permisos, function(i, p){
                            let selected = (p.IdPermiso == data.IdPermiso) ? "selected" : "";
                            $('#editPermiso').append(`<option value="${p.IdPermiso}" ${selected}>${p.NombrePermiso}</option>`);
                        });
                    }
                });

                $('#modalEditarUsuario').modal('show');
            } else {
                alert("No se encontró el usuario");
            }
        },
        error: function(xhr){
            console.error(xhr.responseText);
            alert("Error al cargar datos");
        }
    });
});

// Guardar cambios
$('#formEditarUsuario').on('submit', function(e){
    e.preventDefault();

    $.ajax({
        url: "<?= site_url('usuario/actualizarusuario'); ?>",
        type: "POST",
        data: $(this).serialize(),
        dataType: "json",
        success: function(resp){
            if(resp.status){
                alert("✅ Usuario actualizado correctamente");
                $('#modalEditarUsuario').modal('hide');
                $('#tablaUsuarios').DataTable().ajax.reload(null, false);
            } else {
                alert("❌ Error al actualizar usuario");
            }
        },
        error: function(xhr){
            console.error(xhr.responseText);
            alert("Error al procesar");
        }
    });
});




// Abrir modal de nuevo usuario
$('#btnNuevoUsuario').on('click', function(){
    // Cargar empleados
    $.ajax({
        url: "<?= site_url('usuario/listarempleados'); ?>",
        type: "GET",
        dataType: "json",
        success: function(data){
            let options = '<option value="">Seleccione un empleado</option>';
            $.each(data, function(i, emp){
                options += `<option value="${emp.IdEmpleado}">${emp.NombreEmpleado}</option>`;
            });
            $('#IdEmpleadoNuevo').html(options);
        }
    });

    // Cargar permisos
    $.ajax({
        url: "<?= site_url('usuario/listarpermisos'); ?>",
        type: "GET",
        dataType: "json",
        success: function(data){
            let options = '<option value="">Seleccione un permiso</option>';
            $.each(data, function(i, perm){
                options += `<option value="${perm.IdPermiso}">${perm.NombrePermiso}</option>`;
            });
            $('#IdPermisoNuevo').html(options);
        }
    });

    // Mostrar modal
    var modalNuevo = new bootstrap.Modal(document.getElementById('modalNuevoUsuario'));
    modalNuevo.show();
});

// Guardar nuevo usuario
$('#btnGuardarUsuario').on('click', function(){
    $.ajax({
        url: "<?= site_url('usuario/crear'); ?>",
        type: "POST",
        data: $('#formNuevoUsuario').serialize(),
        dataType: "json",
        success: function(resp){
            if(resp.success){
                alert("Usuario creado con éxito");
                location.reload(); // refrescar tabla
            } else {
                alert("Error: " + resp.message);
            }
        },
        error: function(xhr){
            console.log(xhr.responseText);
            alert("Error al crear usuario");
        }
    });
});


</script>



