<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3  linea-gradiente-suave">
        <h1 class="h2">GESTION DE EMPLEADOS</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
          <div class="btn-group me-2">
            <!-- <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button> -->
          </div>
          <button type="button" class="btn btn-sm btn-outline-secondary" id="btnNuevoEmpleado">
          <span data-feather="user-plus"></span> Nuevo Empleado
          </button>
        </div>
      </div>
  

     
<div class="container mt-5">
  <h3 class="mb-4">Gestión de Empleados</h3>
  <div class="table-responsive">
    <table id="tablaEmpleados" class="table table-striped table-bordered">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Nombre</th>
          <th>Telefono</th>
          <th>Identificación</th>
          <th>DPI</th>
          <th>Dirección</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>


<!-- Modal Nuevo Empleado -->
<div class="modal fade" id="modalNuevoEmpleado" tabindex="-1" aria-labelledby="nuevoEmpleadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="nuevoEmpleadoLabel">Crear Nuevo Empleado</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form id="formNuevoEmpleado">

          <div class="mb-3">
            <label for="NombreEmpleadoNuevo" class="form-label">Nombre de Empleado</label>
            <input type="text" class="form-control" id="NombreEmpleadoNuevo" name="NombreEmpleado" required>
          </div>

          <div class="mb-3">
            <label for="TelefonoNuevo" class="form-label">Telefono</label>
            <input type="text" class="form-control" id="TelefonoNuevo" name="telefono" required>
          </div>

         <div class="mb-3">
            <label for="IdentificacionNuevo" class="form-label">Identificacion</label>
            <input type="text" class="form-control" id="IdentificacionNuevo" name="IdentificacionInterna" required>
          </div>

         <div class="mb-3">
            <label for="DpiNuevo" class="form-label">DPI</label>
            <input type="text" class="form-control" id="DpiNuevo" name="DPI" required>
          </div>
           <div class="mb-3">
            <label for="DireccionNuevo" class="form-label">Direccion</label>
            <input type="text" class="form-control" id="DireccionNuevo" name="Direccion" required>
          </div>

          <!-- Estado van fijos desde backend -->
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-success" id="btnGuardarEmpleado">Guardar Usuario</button>
      </div>
    </div>
  </div>
</div>











<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<script>




//js para mostrar informacion
$(document).ready(function () {
  $('#tablaEmpleados').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?= site_url('empleado/getempleado'); ?>", // ruta al controller
      "type": "POST"
    },
    "columns": [
      { "data": "id" },
      { "data": "nombre" },
      { "data": "telefono" },
      { "data": "identificacion" },
      { "data": "dpi" },
      { "data": "direccion" },
      { "data": "acciones", "orderable": false, "searchable": false }
    ],
    "language": {
      "lengthMenu": "Mostrar _MENU_ entradas",
      "zeroRecords": "No se encontraron resultados",
      "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
      "infoEmpty": "Mostrando 0 a 0 de 0 entradas",
      "infoFiltered": "(filtrado de _MAX_ entradas totales)",
      "search": "Buscar:",
      "paginate": {
        "first": "Primero",
        "last": "Último",
        "next": "Siguiente",
        "previous": "Anterior"
      }
    },
    "pageLength": 10,
    "lengthMenu": [10, 25, 50, 100]
  });
});


//eventos modal nuevo empleado
$(document).ready(function(){

    // Abrir modal
    $('#btnNuevoEmpleado').click(function(){
        $('#formNuevoEmpleado')[0].reset(); // Limpiar formulario
        $('#modalNuevoEmpleado').modal('show');
    });

    // Guardar nuevo empleado
    $('#btnGuardarEmpleado').click(function(){

        let form = $('#formNuevoEmpleado')[0];

        if(!form.checkValidity()){
            form.reportValidity();
            return;
        }

        let formData = $(form).serialize();

        $.ajax({
            url: "<?= site_url('empleado/crear'); ?>",
            type: "POST",
            data: formData,
            dataType: "json",
            success: function(resp){
                if(resp.success){
                    $('#modalNuevoEmpleado').modal('hide');
                    $('#tablaEmpleados').DataTable().ajax.reload(); // Recargar tabla
                    Swal.fire('¡Éxito!', 'Empleado creado correctamente', 'success');
                } else {
                    Swal.fire('Error', resp.message, 'error');
                }
            },
            error: function(xhr){
                console.log(xhr.responseText);
                Swal.fire('Error', 'Error en la petición Ajax', 'error');
            }
        });
    });

});


// Evento para eliminar Empleado
$('#tablaEmpleados').on('click', '.btn-deleteEmpleado', function(){
    var idEmpleado = $(this).data('id');

    if(confirm("¿Seguro que deseas eliminar este empleado?")){
        $.ajax({
            url: "<?= site_url('empleado/deleteempleado'); ?>",
            type: "POST",
            data: { id: idEmpleado },
            dataType: "json",
            success: function(response){
                if(response.success){
                    alert("Empleado eliminado correctamente");
                    $('#tablaEmpleados').DataTable().ajax.reload(null, false);
                } else {
                    alert(response.message); // Muestra mensaje de usuarios asociados
                }
            },
            error: function(){
                alert("Error en la petición Ajax");
            }
        });
    }
});


</script>


