<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3  linea-gradiente-suave">
        <h1 class="h2">GESTION DE CLIENTES</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
          <div class="btn-group me-2">
            <!-- <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button> -->
          </div>
          <button type="button" class="btn btn-sm btn-outline-secondary" id="btnNuevoCliente">
          <span data-feather="user-plus"></span> Nuevo Cliente
          </button>
        </div>
      </div>
  

      <!-- aqui empieza las cards informatias -->
    <div class="card-group">
            <div class="card card-gradient-blue position-relative">
                <div class="card-body">
                    <div>
                        <h2 id="totalEmpleados">0</h2>
                        <p>Clientes</p>
                    </div>
                <i data-feather="user" class="icon-feather"></i>
                </div>
            </div>
            <br>
        <div class="card card-gradient-green position-relative">
             <div class="card-body">
                    <div>
                        <h2 id="totalUsuarios">0</h2>
                        <p>Usuarios</p>
                    </div>
                <i data-feather="user-plus" class="icon-feather"></i>
                </div>
        </div>
         <br>  
        <div class="card card-gradient-orange position-relative">
            <div class="card-body">
                    <div>
                        <h2 id="totalActivos">0</h2>
                        <p>Inactivos</p>
                    </div>
                <i data-feather="user-x" class="icon-feather"></i>
                </div>
        </div>
    </div>
<!-- aqui terminan las cards informativas -->
<div class="container mt-5">
  <h3 class="mb-4">Gestión de Clientes</h3>
  <div class="table-responsive">
    <table id="tablaClientes" class="table table-striped table-bordered">
      <thead class="table-secondary">
        <tr>
          <th>#</th>
          <th>Nombre</th>
          <th>Apellido</th>
          <th>Nit</th>
          <th>Telefono</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>




<!-- Modal Nuevo Cliente -->
<div class="modal fade" id="modalNuevoCliente" tabindex="-1" aria-labelledby="nuevoClienteLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="nuevoClienteLabel">Crear Nuevo Cliente</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form id="formNuevoCliente">
          
          <div class="mb-3">
            <label for="NombreCienteNuevo" class="form-label">Nombre del Cliente</label>
            <input type="text" class="form-control" id="NombreNuevo" name="NombreCliente" required>
          </div>

          <div class="mb-3">
            <label for="ApellidoClienteNuevo" class="form-label">Apellido del Cliente</label>
            <input type="text" class="form-control" id="ApellidoClienteNuevo" name="ApellidoCliente" required>
          </div>

          <div class="mb-3">
            <label for="NitNuevo" class="form-label">NIT</label>
            <input type="text" class="form-control" id="NitNuevo" name="Nit" required>
          </div>

          <div class="mb-3">
            <label for="NoDpiNuevo" class="form-label">No. DPI</label>
            <input type="text" class="form-control" id="NoDpiNuevo" name="DPI" required>     
          </div>

           <div class="mb-3">
            <label for="Telefono1Nuevo" class="form-label">Celular</label>
            <input type="text" class="form-control" id="Telefono1Nuevo" name="Telefono1" required>     
          </div>

           <div class="mb-3">
            <label for="Telefono2Nuevo" class="form-label">Telefono</label>
            <input type="text" class="form-control" id="Telefono2Nuevo" name="Telefono2" >     
          </div>
          <div class="mb-3">
            <label for="DireccionContactoNuevo" class="form-label">Dirección</label>
            <input type="text" class="form-control" id="DireccionContactoNuevo" name="DireccionContacto" required>     
          </div>
          <div class="mb-3">
            <label for="EmailNuevo" class="form-label">Correo Electrónico</label>
            <input type="email" class="form-control" id="EmailNuevo" name="Email" required>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-success" id="btnGuardarCliente">Guardar Cliente</button>
      </div>
    </div>
  </div>
</div>





<!-- Modal Editar Cliente -->
<div class="modal fade" id="modalEditarCliente" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formEditarCliente" class="w-100">
      <div class="modal-content">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title">Editar Datos del Cliente</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body row g-3">
          <input type="hidden" id="editIdCliente" name="IdCliente">

          <div class="col-md-6">
            <label for="editCorreo" class="form-label">Correo Electrónico</label>
            <input type="email" class="form-control" id="editCorreo" name="CorreoElectronico" required>
          </div>

          <div class="col-md-6">
            <label for="editUsuario" class="form-label">Nombre de Usuario</label>
            <input type="text" class="form-control" id="editUsuario" name="NombreUsuario" required>
          </div>

          <div class="col-md-6">
            <label for="editPassword" class="form-label">Contraseña</label>
            <input type="password" class="form-control" id="editPassword" name="UPassword" placeholder="Dejar vacío si no cambia">
          </div>

          <div class="col-md-6">
            <label for="editPermiso" class="form-label">Permiso</label>
            <select class="form-select" id="editPermiso" name="IdPermiso" required></select>
          </div>

          <div class="col-md-6">
            <label for="editEmpleado" class="form-label">Empleado</label>
            <input type="text" class="form-control" id="editEmpleado" name="Empleado" readonly>
          </div>

          <div class="col-md-6">
            <label for="editEstado" class="form-label">Estado</label>
            <select class="form-select" id="editEstado" name="IdEstado" required>
              <option value="1">Activo</option>
              <option value="2">Inactivo</option>
            </select>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success">💾 Guardar cambios</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>













<!-- area de scripts -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>

//js para mostrar informacion
$(document).ready(function () {
  $('#tablaClientes').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?= site_url('cliente/getclientes'); ?>", // ruta al controller
      "type": "POST"
    },
    "columns": [
      { "data": "id" },
      { "data": "Nombre" },
      { "data": "Apellido" },
      { "data": "Nit" },
      { "data": "Telefono" },
      { "data": "acciones", "orderable": false, "searchable": false }
    ],
    "language": {
      "lengthMenu": "Mostrar _MENU_ entradas",
      "zeroRecords": "No se encontraron resultados",
      "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
      "infoEmpty": "Mostrando 0 a 0 de 0 entradas",
      "infoFiltered": "(filtrado de _MAX_ entradas totales)",
      "search": "Buscar:",
      "paginate": {
        "first": "Primero",
        "last": "Último",
        "next": "Siguiente",
        "previous": "Anterior"
      }
    },
    "pageLength": 10,
    "lengthMenu": [10, 25, 50, 100]
  });
});




// Abrir modal de nuevo Cliente
$('#btnNuevoCliente').on('click', function(){
   
    // Mostrar modal
    var modalNuevo = new bootstrap.Modal(document.getElementById('modalNuevoCliente'));
    modalNuevo.show();
});

// Guardar nuevo usuario
$('#btnGuardarCliente').on('click', function(){
    $.ajax({
        url: "<?= site_url('cliente/crear'); ?>",
        type: "POST",
        data: $('#formNuevoCliente').serialize(),
        dataType: "json",
        success: function(resp){
            if(resp.success){
                alert("Cliente creado con éxito");
                location.reload(); // refrescar tabla
            } else {
                alert("Error: " + resp.message);
            }
        },
        error: function(xhr){
            console.log(xhr.responseText);
            alert("Error al crear usuario");
        }
    });
});



 </script>

