<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios_model extends CI_Model {

    var $table = 'usuario u';
    var $column_order = array(null, 'u.NombreUsuario', 'e.NombreEmpleado', 'p.NombrePermiso', 'u.IdEstado'); 
    var $column_search = array('u.NombreUsuario','e.NombreEmpleado','p.NombrePermiso');
    var $order = array('u.IdUsuario' => 'asc');

    private function _get_datatables_query(){
        $this->db->select("u.IdUsuario, u.NombreUsuario, u.IdEstado, e.NombreEmpleado as empleado_nombre, p.NombrePermiso as permiso_nombre");
        $this->db->from('usuario u');
        $this->db->join('empleado e', 'e.IdEmpleado = u.IdEmpleado');
        $this->db->join('permisos p', 'p.IdPermiso = u.IdPermiso');

        $i = 0;
        foreach ($this->column_search as $item){
            if($_POST['search']['value']){
                if($i===0){
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }
                if(count($this->column_search) - 1 == $i)
                    $this->db->group_end();
            }
            $i++;
        }

        if(isset($_POST['order'])){
            $this->db->order_by($this->column_order[$_POST['order'][0]['column']], $_POST['order'][0]['dir']);
        } else if(isset($this->order)){
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    function count_all(){
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    public function delete($id){
    return $this->db->delete('usuario', array('IdUsuario' => $id));
    }

    public function desactivar($id){
    $this->db->set('IdEstado', 2);
    $this->db->where('IdUsuario', $id);
    return $this->db->update('usuario');
    }


    public function getUsuarioById($id){
    $this->db->select('u.IdUsuario, u.CorreoElectronico, u.NombreUsuario, u.IdPermiso, u.IdEstado, 
                       e.NombreEmpleado as EmpleadoNombre');
    $this->db->from('usuario u');
    $this->db->join('empleado e', 'e.IdEmpleado = u.IdEmpleado', 'left');
    $this->db->where('u.IdUsuario', $id);
    return $this->db->get()->row();
    }

    public function getPermisos(){
    return $this->db->get('permisos')->result();
    }

    public function updateUsuario($id, $data){
    $this->db->where('IdUsuario', $id);
    return $this->db->update('usuario', $data);
    }

     public function insertar($data){
        return $this->db->insert('usuario', $data);
    }

    public function countByEstado($estado){
    $this->db->where('IdEstado', $estado);
    $this->db->from('usuario');
    return $this->db->count_all_results();
    }

}