<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Empleado_model extends CI_Model {

    var $column_order = ['NombreEmpleado','Telefono','IdentificacionInterna','DPI','Direccion']; 
    var $column_search = ['NombreEmpleado','Telefono','IdentificacionInterna','DPI','Direccion']; 
    var $order = ['NombreEmpleado' => 'ASC']; 
    var $table = 'empleado';

    public function __construct(){
        parent::__construct();
    }

    private function _get_datatables_query(){
        $this->db->select('IdEmpleado, NombreEmpleado, Telefono, IdentificacionInterna, DPI, Direccion, IdEstado');
        $this->db->from($this->table);

        $search_value = $this->input->post('search')['value'] ?? null;

        if($search_value){
            $this->db->group_start();
            foreach($this->column_search as $i => $item){
                if($i === 0){
                    $this->db->like($item, $search_value);
                } else {
                    $this->db->or_like($item, $search_value);
                }
            }
            $this->db->group_end();
        }

        $order = $this->input->post('order');
        if($order){
            $col_index = $order[0]['column'];
            $dir = $order[0]['dir'];
            $this->db->order_by($this->column_order[$col_index], $dir);
        } else {
            $this->db->order_by(key($this->order), $this->order[key($this->order)]);
        }
    }

    public function get_datatables(){
        $this->_get_datatables_query();
        $length = $this->input->post('length') ?? 10;
        $start = $this->input->post('start') ?? 0;
        if($length != -1){
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        return $query->result();
    }

    public function count_all(){
        return $this->db->count_all($this->table);
    }

    public function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function getEmpleadoById($id){
        $this->db->where('IdEmpleado', $id);
        return $this->db->get($this->table)->row();
    }

   

    public function updateEmpleado($id, $data){
        $this->db->where('IdEmpleado', $id);
        return $this->db->update($this->table, $data);
    }

  public function delete($id){
    return $this->db->delete('empleado', array('IdEmpleado' => $id));
    }
public function deleteEmpleado($id){
    // Verificar si el empleado tiene usuarios asociados
    $this->db->where('IdEmpleado', $id);
    $usuarios = $this->db->get('usuario')->num_rows();

    if($usuarios > 0){
        // Retornar false y mensaje en el controlador
        return ['success' => false, 'message' => 'Este empleado tiene usuarios asociados. Elimínelos primero.'];
    }

    // Si no tiene usuarios, eliminar
    $this->db->where('IdEmpleado', $id);
    $deleted = $this->db->delete('empleado');

    if($deleted){
        return ['success' => true];
    } else {
        return ['success' => false, 'message' => 'Error al eliminar el empleado'];
    }
}

public function insertar($data){
    return $this->db->insert('empleado', $data);
}


}