<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuario extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->model('Usuarios_model');
        $this->load->model('Empleado_model');
          $this->load->model('Permiso_model');
    }

    public function index(){
        $this->load->view('configuracion/usuarios'); // la vista anterior
    } 

//para la parte visual de las cards 
public function dashboardcounts(){
    // Contar empleados
    $numEmpleados = $this->Empleado_model->count_all();
    // Contar usuarios totales
    $numUsuarios = $this->Usuarios_model->count_all();
    // Contar usuarios activos (IdEstado = 2) para los inactivos
    $numUsuariosActivos = $this->Usuarios_model->countByEstado(2);
    // Retornar JSON
    echo json_encode([
        'empleados' => $numEmpleados,
        'usuarios' => $numUsuarios,
        'activos' => $numUsuariosActivos
    ]);
}




    public function getusuarios(){

        
        $usuarios = $this->Usuarios_model->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($usuarios as $u) {
            $no++;
            $row = array();
            $row['id'] = $no;
            $row['usuario'] = $u->NombreUsuario;
            $row['empleado'] = $u->empleado_nombre;
            $row['permiso'] = $u->permiso_nombre;
            $row['activo'] = ($u->IdEstado == 1) ? "<span class='badge bg-success'>Activo</span>" : "<span class='badge bg-danger'>Inactivo</span>";
            
            $row['acciones'] = '
                <button class="btn btn-sm btn-primary btn-editar" data-id="'.$u->IdUsuario.'">Editar</button>
                <button class="btn btn-sm btn-warning btn-desactivar" data-id="'.$u->IdUsuario.'">Desactivar</button>
                <button class="btn btn-sm btn-danger btn-delete" data-id="'.$u->IdUsuario.'">Eliminar</button>
            ';

            $data[] = $row;
        }

        $output = array(
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $this->Usuarios_model->count_all(),
            "recordsFiltered" => $this->Usuarios_model->count_filtered(),
            "data" => $data,
        );
        echo json_encode($output);
    }

    public function deleteusuario(){
             $id = $this->input->post('id');
             $this->load->model('Usuarios_model');
              $result = $this->Usuarios_model->delete($id);
            echo json_encode(["status" => $result]);
    }

    public function desactivarusuario(){
                 $id = $this->input->post('id');
                $this->load->model('Usuarios_model');
                $result = $this->Usuarios_model->desactivar($id);

    header('Content-Type: application/json');
    echo json_encode(["status" => $result]);
    exit;
}


    public function getusuariobyid(){
    $id = $this->input->post('IdUsuario');
    $this->load->model('Usuarios_model');
    $usuario = $this->Usuarios_model->getUsuarioById($id);

    header('Content-Type: application/json');
    echo json_encode($usuario);
    exit;
}

    public function getpermisos(){
    $this->load->model('Usuarios_model');
    $permisos = $this->Usuarios_model->getPermisos();

    header('Content-Type: application/json');
    echo json_encode($permisos);
    exit;
}

    public function actualizarusuario(){
    $id = $this->input->post('IdUsuario');

    $data = [
        'CorreoElectronico'   => $this->input->post('CorreoElectronico'),
        'NombreUsuario'       => $this->input->post('NombreUsuario'),
        'IdPermiso'           => $this->input->post('IdPermiso'),
        'IdEstado'            => $this->input->post('IdEstado'),
        'UltimaModificacion'  => date('Y-m-d H:i:s')
    ];

    // Si hay nueva contraseña, encriptar con sha1
    if(!empty($this->input->post('UPassword'))){
        $data['UPassword'] = sha1($this->input->post('UPassword'));
    }

    $this->load->model('Usuarios_model');
    $result = $this->Usuarios_model->updateUsuario($id, $data);

    header('Content-Type: application/json');
    echo json_encode(["status" => $result]);
    exit;
}



//aqui ya agrego para trabajar un nuevo usuario 

 // Listar empleados para combo
    public function listarempleados(){
        $empleados = $this->Empleado_model->get_datatables();
        echo json_encode($empleados);
    }


 public function listarpermisos(){
        $permisos = $this->Permiso_model->getAll();
        echo json_encode($permisos);
    }


public function crear(){
    $correo = $this->input->post('CorreoElectronico');
    $usuario = $this->input->post('NombreUsuario');
    $password = $this->input->post('UPassword');
    $idPermiso = $this->input->post('IdPermiso');
    $idEmpleado = $this->input->post('IdEmpleado');

    // Validar campos obligatorios
    if(empty($correo) || empty($usuario) || empty($password) || empty($idPermiso) || empty($idEmpleado)){
        echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios']);
        return;
    }

    // Validar que no exista el usuario
    $existe = $this->db->where('NombreUsuario', $usuario)
                       ->or_where('CorreoElectronico', $correo)
                       ->get('usuario')
                       ->row();

    if($existe){
        echo json_encode(['success' => false, 'message' => 'El usuario o correo ya existe']);
        return;
    }

    $data = [
        'CorreoElectronico' => $correo,
        'NombreUsuario' => $usuario,
        'UPassword' => sha1($password),
        'UltimaModificacion' => date('Y-m-d H:i:s'),
        'IdPermiso' => $idPermiso,
        'IdEmpleado' => $idEmpleado,
        'IdEstado' => 1, // activo por defecto
        'IdEstablecimiento' => 1 // fijo
    ];

    $insert = $this->Usuarios_model->insertar($data);

    if($insert){
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al guardar el usuario']);
    }
    }






}