<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Empleado extends CI_Controller {

    public function __construct(){
        parent::__construct();
        
        $this->load->model('Empleado_model');
      
    }

    public function index(){
        $this->load->view('configuracion/empleados'); // la vista anterior
    }



      public function getempleado(){
    $empleados = $this->Empleado_model->get_datatables();
    $data = [];
    $no = intval($this->input->post('start')) ?? 0;

    foreach ($empleados as $e) {
        $no++;
        $data[] = [
            'id' => $no,
            'nombre' => $e->NombreEmpleado,
            'telefono' => $e->Telefono,
            'identificacion' => $e->IdentificacionInterna,
            'dpi' => $e->DPI,
            'direccion' => $e->Direccion,
            'acciones' => '
                <button class="btn btn-sm btn-primary btn-editar" data-id="'.$e->IdEmpleado.'">Editar</button>            
                <button class="btn btn-sm btn-danger btn-deleteEmpleado" data-id="'.$e->IdEmpleado.'">Eliminar</button>
            '
        ];
    }

    $output = [
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $this->Empleado_model->count_all(),
        "recordsFiltered" => $this->Empleado_model->count_filtered(),
        "data" => $data,
    ];

    $this->output
         ->set_content_type('application/json')
         ->set_output(json_encode($output));
}



public function crear(){
    $nombre = $this->input->post('NombreEmpleado');
    $telefono = $this->input->post('telefono');
    $identificacion = $this->input->post('IdentificacionInterna');
    $dpi = $this->input->post('DPI');
    $direccion = $this->input->post('Direccion');

    // Validar campos obligatorios
    if(empty($nombre) || empty($telefono) || empty($identificacion) || empty($dpi) || empty($direccion)){
        echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios']);
        return;
    }

    // Validar que no exista empleado con la misma Identificación
    $existe = $this->db->where('IdentificacionInterna', $identificacion)
                       ->or_where('DPI', $dpi)
                       ->get('empleado')
                       ->row();

    if($existe){
        echo json_encode(['success' => false, 'message' => 'Ya existe un empleado con la misma identificación o DPI']);
        return;
    }

    $data = [
        'NombreEmpleado' => $nombre,
        'Telefono' => $telefono,
        'IdentificacionInterna' => $identificacion,
        'DPI' => $dpi,
        'Direccion' => $direccion,
        'IdEstado' => 1 // activo por defecto
    ];

    $insert = $this->Empleado_model->insertar($data);

    if($insert){
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al guardar el empleado']);
    }
}




public function deleteempleado(){
    $id = $this->input->post('id');
    $this->load->model('Empleado_model');

    $result = $this->Empleado_model->deleteEmpleado($id);

    echo json_encode($result);
}


}